/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

class SuddenSalvationEffect
extends OneShotEffect {
    SuddenSalvationEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to three target permanent cards in graveyards that were put there from the battlefield this turn. Return them to the battlefield tapped under their owners' control. You draw a card for each opponent who controls one or more of those permanents";
    }

    private SuddenSalvationEffect(SuddenSalvationEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuddenSalvationEffect copy() {
        return new SuddenSalvationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (player == null || cards.isEmpty()) {
            return false;
        }
        player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, true, false, true, null);
        int opponents = cards.stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(Controllable::getControllerId).distinct().mapToInt(uuid -> player.hasOpponent(uuid, game) ? 1 : 0).sum();
        player.drawCards(opponents, source, game);
        return true;
    }
}

