/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SuddenSpoilingEffect
extends ContinuousEffectImpl {
    SuddenSpoilingEffect(Duration duration) {
        super(duration, Outcome.LoseAbility);
        this.staticText = "Until end of turn, creatures target player controls lose all abilities and have base power and toughness 0/2";
    }

    private SuddenSpoilingEffect(SuddenSpoilingEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SuddenSpoilingEffect copy() {
        return new SuddenSpoilingEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return;
        }
        for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game)) {
            this.affectedObjectList.add(new MageObjectReference((MageObject)perm, game));
        }
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game)) {
            if (!this.affectedObjectList.contains(new MageObjectReference((MageObject)permanent, game))) continue;
            switch (layer) {
                case AbilityAddingRemovingEffects_6: {
                    permanent.removeAllAbilities(source.getSourceId(), game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(0);
                    permanent.getToughness().setModifiedBaseValue(2);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.PTChangingEffects_7;
    }
}

