/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SuddenSubstitutionEffect
extends OneShotEffect {
    SuddenSubstitutionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exchange control of target noncreature spell and target creature. Then the spell's controller may choose new targets for it.";
    }

    private SuddenSubstitutionEffect(SuddenSubstitutionEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuddenSubstitutionEffect copy() {
        return new SuddenSubstitutionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(((Target)source.getTargets().get(0)).getFirstTarget());
        Permanent creature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (spell == null || creature == null) {
            return false;
        }
        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, spell.getControllerId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
        spell.setControllerId(creature.getControllerId());
        spell.chooseNewTargets(game, creature.getControllerId());
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

