/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.util.CardUtil;

class SulfuricVaporsEffect
extends ReplacementEffectImpl {
    SulfuricVaporsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a red spell would deal damage to a permanent or player, it deals that much damage plus 1 to that permanent or player instead";
    }

    private SulfuricVaporsEffect(SulfuricVaporsEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public SulfuricVaporsEffect copy() {
        return new SulfuricVaporsEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        StackObject spell = game.getStack().getStackObject(event.getSourceId());
        return spell != null && spell.getColor(game).isRed();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

