/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SummonEsperMaduinEffect
extends OneShotEffect {
    SummonEsperMaduinEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. If it's a permanent card, put it into your hand";
    }

    private SummonEsperMaduinEffect(SummonEsperMaduinEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonEsperMaduinEffect copy() {
        return new SummonEsperMaduinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.isPermanent(game)) {
            player.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

