/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.cards.Card;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SummonEsperValigarmandaCastEffect
extends OneShotEffect {
    private static final DynamicValue xValue = new CountersSourceCount(CounterType.LORE);

    SummonEsperValigarmandaCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "add {R} for each lore counter on {this}. You may cast an instant or sorcery card exiled with {this}, and mana of any type can be spent to cast that spell";
    }

    private SummonEsperValigarmandaCastEffect(SummonEsperValigarmandaCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonEsperValigarmandaCastEffect copy() {
        return new SummonEsperValigarmandaCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = xValue.calculate(game, source, (Effect)this);
        if (count > 0) {
            player.getManaPool().addMana(Mana.RedMana((int)count), game, source);
        }
        TargetCardInExile target = new TargetCardInExile(0, 1, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, CardUtil.getExileZoneId((Game)game, (Ability)source));
        target.withNotTarget(true);
        target.withChooseHint("to cast");
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && new MayCastTargetCardEffect(CastManaAdjustment.AS_THOUGH_ANY_MANA_TYPE).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
    }
}

