/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SummonersEggPutOntoBattlefieldEffect
extends OneShotEffect {
    SummonersEggPutOntoBattlefieldEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "turn the exiled card face up. If it's a creature card, put it onto the battlefield under your control";
    }

    private SummonersEggPutOntoBattlefieldEffect(SummonersEggPutOntoBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonersEggPutOntoBattlefieldEffect copy() {
        return new SummonersEggPutOntoBattlefieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card imprintedCard;
            Permanent SummonersEgg2 = game.getPermanentOrLKIBattlefield(source.getSourceId());
            if (SummonersEgg2 != null && SummonersEgg2.getImprinted() != null && !SummonersEgg2.getImprinted().isEmpty() && (imprintedCard = game.getCard((UUID)SummonersEgg2.getImprinted().get(0))) != null && game.getState().getZone(imprintedCard.getId()) == Zone.EXILED) {
                imprintedCard.turnFaceUp(source, game, source.getControllerId());
                if (imprintedCard.isCreature(game)) {
                    controller.moveCards(imprintedCard, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

