/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.players.Player;

class SummonersSendingEffect
extends OneShotEffect {
    SummonersSendingEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature card from a graveyard. If you do, create a 1/1 white Spirit creature token with flying. Put a +1/+1 counter on it if the exiled card's mana value is 4 or greater";
    }

    private SummonersSendingEffect(SummonersSendingEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonersSendingEffect copy() {
        return new SummonersSendingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        SpiritWhiteToken token = new SpiritWhiteToken();
        token.putOntoBattlefield(1, game, source);
        if (card.getManaValue() < 4) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Optional.ofNullable(tokenId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.addCounters(CounterType.P1P1.createInstance(), source, game));
        }
        return true;
    }
}

