/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.IncubateEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class SunfallEffect
extends OneShotEffect {
    SunfallEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all creatures. Incubate X, where X is the number of creatures exiled this way";
    }

    private SunfallEffect(SunfallEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunfallEffect copy() {
        return new SunfallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        IncubateEffect.doIncubate((int)cards.size(), (Game)game, (Ability)source);
        return true;
    }
}

