/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.UseAttachedCost;
import mage.abilities.costs.common.SacrificeAttachmentCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.continuous.GainAbilityWithAttachmentEffect;
import mage.game.Game;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class SunfireTorchEffect
extends GainAbilityWithAttachmentEffect {
    SunfireTorchEffect() {
        super("and has \"Whenever this creature attacks, you may sacrifice {this}. When you do, this creature deals 2 damage to any target.\"", (Effect)null, null, (UseAttachedCost)new SacrificeAttachmentCost(), new Cost[0]);
    }

    private SunfireTorchEffect(SunfireTorchEffect effect) {
        super((GainAbilityWithAttachmentEffect)effect);
    }

    public SunfireTorchEffect copy() {
        return new SunfireTorchEffect(this);
    }

    protected Ability makeAbility(Game game, Ability source) {
        if (source == null || game == null || source.getSourcePermanentIfItStillExists(game) == null) {
            return null;
        }
        String sourceName = source.getSourcePermanentIfItStillExists(game).getName();
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(2, "this creature"), false);
        ability.addTarget((Target)new TargetAnyTarget());
        return new AttacksTriggeredAbility((Effect)new DoWhenCostPaid(ability, (Cost)this.useAttachedCost.copy().setMageObjectReference(source, game), "Sacrifice " + sourceName + "?"), false, "Whenever this creature attacks, you may sacrifice " + sourceName + ". When you do, this creature deals 2 damage to any target.");
    }
}

