/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.ManaPoolItem;

class SunglassesOfUrzaManaAsThoughtEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    public SunglassesOfUrzaManaAsThoughtEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may spend white mana as though it were red mana";
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        return source.isControlledBy(affectedControllerId);
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        if (mana.getWhite() > 0 && ManaType.RED == manaType) {
            return ManaType.WHITE;
        }
        return null;
    }

    public SunglassesOfUrzaManaAsThoughtEffect copy() {
        return new SunglassesOfUrzaManaAsThoughtEffect(this);
    }

    private SunglassesOfUrzaManaAsThoughtEffect(SunglassesOfUrzaManaAsThoughtEffect effect) {
        super((AsThoughEffectImpl)effect);
    }
}

