/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;

class SunhomeEnforcerTriggeredAbility
extends TriggeredAbilityImpl {
    public SunhomeEnforcerTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private SunhomeEnforcerTriggeredAbility(SunhomeEnforcerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SunhomeEnforcerTriggeredAbility copy() {
        return new SunhomeEnforcerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT || event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedEvent damageEvent = (DamagedEvent)event;
        if (damageEvent.isCombatDamage() && event.getSourceId().equals(this.sourceId)) {
            this.getEffects().clear();
            this.getEffects().add((Object)new GainLifeEffect(damageEvent.getAmount()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} deals combat damage, you gain that much life.";
    }
}

