/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

class SunspineLynxEffect
extends OneShotEffect {
    SunspineLynxEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals damage to each player equal to the number of nonbasic lands that player controls";
    }

    private SunspineLynxEffect(SunspineLynxEffect effect) {
        super((OneShotEffect)effect);
    }

    public SunspineLynxEffect copy() {
        return new SunspineLynxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Map<UUID, Integer> map = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS_NONBASIC, source.getSourceId(), source, game).stream().collect(Collectors.toMap(Controllable::getControllerId, x -> 1, Integer::sum));
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            int amount = map.getOrDefault(playerId, 0);
            if (player == null || amount <= 0) continue;
            player.damage(amount, source, game);
        }
        return true;
    }
}

