/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class SuperiorNumbersEffect
extends OneShotEffect {
    SuperiorNumbersEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to target creature equal to the number of creatures you control in excess of the number of creatures target opponent controls.";
    }

    private SuperiorNumbersEffect(SuperiorNumbersEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuperiorNumbersEffect copy() {
        return new SuperiorNumbersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int opponentCreatures;
        Permanent creature = game.getPermanent(source.getFirstTarget());
        Player opponent = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (creature == null || opponent == null || controller == null) {
            return false;
        }
        int controllerCreatures = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game);
        int damage = Math.max(controllerCreatures - (opponentCreatures = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, opponent.getId(), game)), 0);
        return creature.damage(damage, source.getSourceId(), source, game) > 0;
    }
}

