/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class SuppressionFieldCostReductionEffect
extends CostModificationEffectImpl {
    SuppressionFieldCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Activated abilities cost {2} more to activate unless they're mana abilities";
    }

    private SuppressionFieldCostReductionEffect(SuppressionFieldCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.isNonManaActivatedAbility();
    }

    public SuppressionFieldCostReductionEffect copy() {
        return new SuppressionFieldCostReductionEffect(this);
    }
}

