/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SwiftWarkiteEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature card with mana value 3 or less");

    SwiftWarkiteEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may put a creature card with mana value 3 or less from your hand or graveyard onto the battlefield. That creature gains haste. Return it to your hand at the beginning of the next end step";
    }

    private SwiftWarkiteEffect(SwiftWarkiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwiftWarkiteEffect copy() {
        return new SwiftWarkiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)controller.getHand().getCards(filter, source.getControllerId(), source, game));
        cards.addAllCards((Collection)controller.getGraveyard().getCards(filter, source.getControllerId(), source, game));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(0, 1, Zone.ALL, filter);
        target.withNotTarget(true);
        controller.choose(this.outcome, (Cards)cards, target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            GainAbilityTargetEffect gainHasteEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
            gainHasteEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)gainHasteEffect, source);
            ReturnToHandTargetEffect returnToHandEffect = new ReturnToHandTargetEffect();
            returnToHandEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)returnToHandEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
    }
}

