/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapAllLandsControllerEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SwordOfFeastAndFamineAbility
extends TriggeredAbilityImpl {
    public SwordOfFeastAndFamineAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DiscardTargetEffect(1));
        this.addEffect((Effect)new UntapAllLandsControllerEffect());
    }

    private SwordOfFeastAndFamineAbility(SwordOfFeastAndFamineAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SwordOfFeastAndFamineAbility copy() {
        return new SwordOfFeastAndFamineAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent p = game.getPermanent(event.getSourceId());
        if (damageEvent.isCombatDamage() && p != null && p.getAttachments().contains(this.getSourceId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature deals combat damage to a player, that player discards a card and you untap all lands you control.";
    }
}

