/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.SwordOfOnceAndFutureTracker;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SwordOfOnceAndFutureCastEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterInstantOrSorceryCard();

    SwordOfOnceAndFutureCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may cast an instant or sorcery spell with mana value 2 or less from your graveyard without paying its mana cost. If that spell would be put into your graveyard, exile it instead";
    }

    private SwordOfOnceAndFutureCastEffect(SwordOfOnceAndFutureCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwordOfOnceAndFutureCastEffect copy() {
        return new SwordOfOnceAndFutureCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)player.getGraveyard()), (FilterCard)filter, (CardUtil.SpellCastTracker)SwordOfOnceAndFutureTracker.instance);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

