/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SwordOfTheAgesEffect
extends OneShotEffect {
    SwordOfTheAgesEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to any target, where X is the total power of the creatures sacrificed this way, then exile {this} and those creature cards";
    }

    private SwordOfTheAgesEffect(SwordOfTheAgesEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwordOfTheAgesEffect copy() {
        return new SwordOfTheAgesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashSet<Card> cardsToExile = new HashSet<Card>();
        if (controller != null) {
            int totalPower = 0;
            Card card = game.getCard(source.getSourceId());
            if (card != null) {
                cardsToExile.add(card);
            }
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof SacrificeTargetCost)) continue;
                for (Permanent permanent : ((SacrificeTargetCost)cost).getPermanents()) {
                    totalPower += permanent.getPower().getValue();
                    Card permanentCard = game.getCard(permanent.getId());
                    if (permanentCard == null) continue;
                    cardsToExile.add(permanentCard);
                }
            }
            if (totalPower > 0) {
                Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
                if (player != null) {
                    player.damage(totalPower, source.getSourceId(), source, game);
                } else {
                    Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                    if (creature != null) {
                        creature.damage(totalPower, source.getSourceId(), source, game, false, true);
                    }
                }
            }
            return controller.moveCards(cardsToExile, Zone.EXILED, source, game);
        }
        return false;
    }
}

