/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SwordOfTheMeekEffect
extends OneShotEffect {
    SwordOfTheMeekEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may return this card from your graveyard to the battlefield, then attach it to that creature";
    }

    private SwordOfTheMeekEffect(SwordOfTheMeekEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwordOfTheMeekEffect copy() {
        return new SwordOfTheMeekEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card equipment = game.getCard(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (equipment != null && controller != null && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD) {
            controller.moveCards(equipment, Zone.BATTLEFIELD, source, game);
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                return permanent.addAttachment(equipment.getId(), source, game);
            }
        }
        return false;
    }
}

