/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class SwordPointDiplomacyEffect
extends OneShotEffect {
    SwordPointDiplomacyEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top three cards of your library. For each of those cards, put that card into your hand unless any opponent pays 3 life. Then exile the rest.";
    }

    private SwordPointDiplomacyEffect(SwordPointDiplomacyEffect effect) {
        super((OneShotEffect)effect);
    }

    public SwordPointDiplomacyEffect copy() {
        return new SwordPointDiplomacyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        int amount = Math.min(controller.getLibrary().size(), 3);
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)controller.getLibrary().getTopCards(game, amount));
        controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
        Set cardsList = cards.getCards(game);
        CardsImpl cardsToHand = new CardsImpl();
        for (Card card : cardsList) {
            boolean keepIt = true;
            PayLifeCost cost = new PayLifeCost(3);
            for (UUID oppId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(oppId);
                if (opponent == null || !cost.canPay(source, source, opponent.getId(), game) || !opponent.chooseUse(Outcome.Neutral, "Pay 3 life to prevent " + controller.getLogName() + " from getting " + card.getLogName() + "?", source, game) || !cost.pay(source, game, source, opponent.getId(), true)) continue;
                keepIt = false;
            }
            if (!keepIt) continue;
            cardsToHand.add(card);
            cards.remove(card);
        }
        controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        return true;
    }
}

