/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.CardIdPredicate;
import mage.cards.s.SylvanLibraryCardsDrawnThisTurnWatcher;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class SylvanLibraryEffect
extends OneShotEffect {
    SylvanLibraryEffect() {
        super(Outcome.LoseLife);
        this.staticText = "you may draw two additional cards. If you do, choose two cards in your hand drawn this turn. For each of those cards, pay 4 life or put the card on top of your library";
    }

    private SylvanLibraryEffect(SylvanLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public SylvanLibraryEffect copy() {
        return new SylvanLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.drawCards(2, source, game);
            SylvanLibraryCardsDrawnThisTurnWatcher watcher = (SylvanLibraryCardsDrawnThisTurnWatcher)game.getState().getWatcher(SylvanLibraryCardsDrawnThisTurnWatcher.class);
            if (watcher != null) {
                CardsImpl cards = new CardsImpl();
                Set<UUID> cardsDrawnThisTurn = watcher.getCardsDrawnThisTurn(controller.getId());
                for (UUID cardId : controller.getHand()) {
                    Card card;
                    if (cardsDrawnThisTurn == null || !cardsDrawnThisTurn.contains(cardId) || (card = game.getCard(cardId)) == null) continue;
                    cards.add(card);
                }
                int numberOfTargets = Math.min(2, cards.size());
                if (numberOfTargets > 0) {
                    FilterCard filter = new FilterCard(numberOfTargets + " cards of cards drawn this turn");
                    filter.add((Predicate)new CardIdPredicate((Cards)cards));
                    TargetCardInHand target = new TargetCardInHand(numberOfTargets, filter);
                    controller.choose(this.outcome, (Target)target, source, game);
                    CardsImpl cardsPutBack = new CardsImpl();
                    for (UUID cardId : target.getTargets()) {
                        Card card = cards.get(cardId, game);
                        if (card == null) continue;
                        if (controller.canPayLifeCost(source) && controller.getLife() >= 4 && controller.chooseUse(this.outcome, "Pay 4 life for " + card.getLogName() + "? (Otherwise it's put on top of your library)", source, game)) {
                            controller.loseLife(4, game, source, false);
                            game.informPlayers(controller.getLogName() + " pays 4 life to keep a card on hand");
                            continue;
                        }
                        cardsPutBack.add(card);
                    }
                    controller.putCardsOnTopOfLibrary((Cards)cardsPutBack, game, source, true);
                }
            }
            return true;
        }
        return false;
    }
}

