/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class SyphonMindEffect
extends OneShotEffect {
    SyphonMindEffect() {
        super(Outcome.Discard);
        this.staticText = "Each other player discards a card. You draw a card for each card discarded this way";
    }

    private SyphonMindEffect(SyphonMindEffect effect) {
        super((OneShotEffect)effect);
    }

    public SyphonMindEffect copy() {
        return new SyphonMindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount = 0;
        boolean result = false;
        Player you = game.getPlayer(source.getControllerId());
        if (you != null) {
            for (UUID playerId : game.getState().getPlayersInRange(you.getId(), game)) {
                Card card;
                TargetCardInHand target;
                Player otherPlayer;
                if (playerId.equals(you.getId()) || (otherPlayer = game.getPlayer(playerId)) == null || otherPlayer.getHand().isEmpty() || !otherPlayer.choose(Outcome.Discard, (Target)(target = new TargetCardInHand()), source, game) || (card = game.getCard(target.getFirstTarget())) == null || !otherPlayer.discard(card, false, source, game)) continue;
                ++amount;
                result = true;
                target.clearChosen();
            }
            you.drawCards(amount, source, game);
        }
        return result;
    }
}

