/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class SyrVondamSunstarExemplarFirstTriggeredAbility
extends TriggeredAbilityImpl {
    SyrVondamSunstarExemplarFirstTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()));
        this.addEffect((Effect)new GainLifeEffect(1).concatBy("and"));
        this.setTriggerPhrase("Whenever another creature you control dies or is put into exile, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private SyrVondamSunstarExemplarFirstTriggeredAbility(SyrVondamSunstarExemplarFirstTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SyrVondamSunstarExemplarFirstTriggeredAbility copy() {
        return new SyrVondamSunstarExemplarFirstTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return Zone.BATTLEFIELD.match(zEvent.getFromZone()) && (Zone.GRAVEYARD.match(zEvent.getToZone()) || Zone.EXILED.match(zEvent.getToZone())) && StaticFilters.FILTER_ANOTHER_CREATURE_YOU_CONTROL.match(zEvent.getTarget(), this.getControllerId(), (Ability)this, game);
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

