/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.CardType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class TargetPermanentsThatShareCardType
extends TargetPermanent {
    TargetPermanentsThatShareCardType() {
        super(2, 2, StaticFilters.FILTER_PERMANENT, false);
        this.targetName = "permanents that share a card type";
    }

    private TargetPermanentsThatShareCardType(TargetPermanentsThatShareCardType target) {
        super((TargetPermanent)target);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (super.canTarget(playerId, id, source, game)) {
            if (!this.getTargets().isEmpty()) {
                Permanent targetOne = game.getPermanent((UUID)this.getTargets().get(0));
                Permanent targetTwo = game.getPermanent(id);
                if (targetOne == null || targetTwo == null) {
                    return false;
                }
                return targetOne.shareTypes((Card)targetTwo, game);
            }
            return true;
        }
        return false;
    }

    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        HashSet cardTypes = new HashSet();
        MageObject targetSource = game.getObject(source);
        if (targetSource != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
                if (!permanent.canBeTargetedBy(targetSource, sourceControllerId, source, game)) continue;
                for (CardType cardType : permanent.getCardType(game)) {
                    if (!cardTypes.contains(cardType)) continue;
                    return true;
                }
                cardTypes.addAll(permanent.getCardType(game));
            }
        }
        return false;
    }

    public TargetPermanentsThatShareCardType copy() {
        return new TargetPermanentsThatShareCardType(this);
    }
}

