/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.t.AddCardSubTypeEnteringTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AddSubtypeEnteringCreatureEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;
    private final SubType subType;

    AddSubtypeEnteringCreatureEffect(MageObjectReference mor, SubType subType, Outcome outcome) {
        super(Duration.WhileOnBattlefield, outcome);
        this.mor = mor;
        this.subType = subType;
    }

    private AddSubtypeEnteringCreatureEffect(AddSubtypeEnteringCreatureEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
        this.subType = effect.subType;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject spell = game.getObject(event.getSourceId());
        return spell != null && this.mor.refersTo(spell, game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Spell target = game.getSpell(event.getSourceId());
        if (target != null) {
            AddCardSubTypeEnteringTargetEffect effect = new AddCardSubTypeEnteringTargetEffect(this.mor, this.subType, Duration.WhileOnBattlefield);
            effect.setTargetPointer((TargetPointer)new FixedTarget((Card)target, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return false;
    }

    public AddSubtypeEnteringCreatureEffect copy() {
        return new AddSubtypeEnteringCreatureEffect(this);
    }
}

