/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class FlamethrowerSonataEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreatureOrPlaneswalkerPermanent("creature or planeswalker you don't control");

    FlamethrowerSonataEffect() {
        super(Outcome.Benefit);
        this.staticText = "Discard a card, then draw a card. When you discard an instant or sorcery card this way, {this} deals damage equal to that card's mana value to target creature or planeswalker you don't control.";
    }

    private FlamethrowerSonataEffect(FlamethrowerSonataEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlamethrowerSonataEffect copy() {
        return new FlamethrowerSonataEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.discardOne(false, false, source, game);
        player.drawCards(1, source, game);
        if (card == null || !card.isInstantOrSorcery(game)) {
            return true;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(card.getManaValue()), false, "{this} deals damage equal to that card's mana value to target creature or planeswalker you don't control");
        ability.addTarget((Target)new TargetPermanent(filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
    }
}

