/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.Card;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class ProtectionFromPlayerAbility
extends ProtectionAbility {
    public ProtectionFromPlayerAbility() {
        super((Filter)new FilterCard());
    }

    private ProtectionFromPlayerAbility(ProtectionFromPlayerAbility ability) {
        super((ProtectionAbility)ability);
    }

    public ProtectionFromPlayerAbility copy() {
        return new ProtectionFromPlayerAbility(this);
    }

    public String getRule() {
        return "{this} has protection from the chosen player.";
    }

    public boolean canTarget(MageObject source, Game game) {
        UUID playerId = (UUID)game.getState().getValue(this.getSourceId() + "_player");
        if (playerId != null && source != null) {
            if (source instanceof Permanent) {
                return !((Permanent)source).isControlledBy(playerId);
            }
            if (source instanceof Spell) {
                return !((Spell)source).isControlledBy(playerId);
            }
            if (source instanceof StackObject) {
                return !((StackObject)source).isControlledBy(playerId);
            }
            if (source instanceof Card) {
                return !((Card)source).isOwnedBy(playerId);
            }
        }
        return true;
    }
}

