/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class T45PowerArmorEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>(Arrays.asList("Menace", "Trample", "Lifelink"));

    T45PowerArmorEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "untap equipped creature, then put your choice of a menace, trample, or lifelink counter on it";
    }

    private T45PowerArmorEffect(T45PowerArmorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent attachment = source.getSourcePermanentIfItStillExists(game);
        if (player == null || attachment == null) {
            return false;
        }
        Permanent creature = game.getPermanent(attachment.getAttachedTo());
        if (creature == null) {
            return false;
        }
        creature.untap(game);
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose menace, trample, or lifelink");
        choice.setChoices(choices);
        player.choose(this.outcome, (Choice)choice, game);
        String chosen = choice.getChoice();
        if (chosen != null) {
            creature.addCounters(CounterType.findByName((String)chosen.toLowerCase(Locale.ENGLISH)).createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }

    public T45PowerArmorEffect copy() {
        return new T45PowerArmorEffect(this);
    }
}

