/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.TargetPointer;

class TadeasJuniperAscendantEvasionEffect
extends RestrictionEffect {
    TadeasJuniperAscendantEvasionEffect(TargetPointer targetPointer) {
        super(Duration.EndOfCombat);
        this.setTargetPointer(targetPointer);
        this.staticText = "and can't be blocked by creatures with greater power";
    }

    private TadeasJuniperAscendantEvasionEffect(TadeasJuniperAscendantEvasionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(permanent.getId());
    }

    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return blocker.getPower().getValue() <= attacker.getPower().getValue();
    }

    public TadeasJuniperAscendantEvasionEffect copy() {
        return new TadeasJuniperAscendantEvasionEffect(this);
    }
}

