/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TahngarthFirstMateEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TahngarthFirstMateTriggeredAbility
extends TriggeredAbilityImpl {
    TahngarthFirstMateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TahngarthFirstMateEffect(), true);
    }

    private TahngarthFirstMateTriggeredAbility(TahngarthFirstMateTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TahngarthFirstMateTriggeredAbility copy() {
        return new TahngarthFirstMateTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.getOpponents(this.getControllerId()).contains(game.getActivePlayerId()) && !game.getCombat().getAttackers().isEmpty();
    }

    public boolean checkInterveningIfClause(Game game) {
        Permanent permanent = game.getPermanent(this.getSourceId());
        return permanent != null && permanent.isTapped();
    }

    public String getRule() {
        return "Whenever an opponent attacks with one or more creatures, if {this} is tapped, you may have that opponent gain control of {this} until end of combat. If you do, choose a player or planeswalker that opponent is attacking. {this} is attacking that player or planeswalker.";
    }
}

