/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TahngarthsGlareEffect
extends OneShotEffect {
    TahngarthsGlareEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top three cards of target opponent's library, then put them back in any order. That player looks at the top three cards of your library, then puts them back in any order";
    }

    private TahngarthsGlareEffect(TahngarthsGlareEffect effect) {
        super((OneShotEffect)effect);
    }

    public TahngarthsGlareEffect copy() {
        return new TahngarthsGlareEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        TahngarthsGlareEffect.lookAndPutBack(controller, opponent, source, game);
        TahngarthsGlareEffect.lookAndPutBack(opponent, controller, source, game);
        return true;
    }

    private static final void lookAndPutBack(Player player1, Player player2, Ability source, Game game) {
        CardsImpl cards = new CardsImpl(player2.getLibrary().getTopCards(game, 3));
        player1.lookAtCards(player2.getName() + "'s library", (Cards)cards, game);
        player1.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
    }
}

