/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TaintedSpecterEffect
extends OneShotEffect {
    TaintedSpecterEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target player discards a card unless they put a card from their hand on top of their library. If that player discards a card this way, {this} deals 1 damage to each creature and each player";
    }

    private TaintedSpecterEffect(TaintedSpecterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null) {
            return false;
        }
        if (targetPlayer.getHand().isEmpty()) {
            return true;
        }
        String message = "Discard a card, or put a card from your hand on top of your library?";
        if (targetPlayer.chooseUse(this.outcome, "Discard a card, or put a card from your hand on top of your library?", null, "Discard a card", "Put a card from your hand on top", source, game)) {
            DiscardTargetEffect discardEffect = new DiscardTargetEffect(1);
            discardEffect.setTargetPointer((TargetPointer)new FixedTarget(targetPlayer.getId()));
            if (discardEffect.apply(game, source)) {
                new DamageEverythingEffect(1).apply(game, source);
            }
        } else {
            TargetCardInHand target = new TargetCardInHand().withChooseHint("to put on top of your library");
            targetPlayer.choose(Outcome.Detriment, (Target)target, source, game);
            Card card = targetPlayer.getHand().get(target.getFirstTarget(), game);
            if (card != null) {
                targetPlayer.moveCardToLibraryWithInfo(card, source, game, Zone.HAND, true, false);
            }
        }
        return true;
    }

    public TaintedSpecterEffect copy() {
        return new TaintedSpecterEffect(this);
    }
}

