/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.ManaUtil;

class TajNarSwordsmithEffect
extends OneShotEffect {
    TajNarSwordsmithEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. If you do, search your library for an Equipment card with mana value X or less, put that card onto the battlefield, then shuffle";
    }

    private TajNarSwordsmithEffect(TajNarSwordsmithEffect effect) {
        super((OneShotEffect)effect);
    }

    public TajNarSwordsmithEffect copy() {
        return new TajNarSwordsmithEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.chooseUse(Outcome.Benefit, "Do you want to pay {X} to search and put Equipment?", source, game)) {
            int payCount = ManaUtil.playerPaysXGenericMana((boolean)true, (String)"Taj-Nar Swordsmith", (Player)player, (Ability)source, (Game)game);
            FilterCard filter = new FilterCard("Equipment card with mana value {" + payCount + "} or less");
            filter.add((Predicate)SubType.EQUIPMENT.getPredicate());
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, payCount + 1));
            new SearchLibraryPutInPlayEffect(new TargetCardInLibrary(0, 1, filter), false).apply(game, source);
            return true;
        }
        return false;
    }
}

