/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class TakenumaAbandonedMireEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature or planeswalker card");

    TakenumaAbandonedMireEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill three cards, then return a creature or planeswalker card from your graveyard to your hand. This ability costs {1} less to activate for each legendary creature you control";
    }

    private TakenumaAbandonedMireEffect(TakenumaAbandonedMireEffect effect) {
        super((OneShotEffect)effect);
    }

    public TakenumaAbandonedMireEffect copy() {
        return new TakenumaAbandonedMireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(3, source, game);
        if (player.getGraveyard().count(filter, game) < 1) {
            return true;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
        return player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

