/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.t.TakklemaggotUpkeepAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TakklemaggotNonAuraEffect
extends ContinuousEffectImpl {
    private final UUID playerId;

    TakklemaggotNonAuraEffect(UUID playerId) {
        super(Duration.Custom, Outcome.AddAbility);
        this.playerId = playerId;
    }

    private TakklemaggotNonAuraEffect(TakklemaggotNonAuraEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.playerId = effect.playerId;
    }

    public TakklemaggotNonAuraEffect copy() {
        return new TakklemaggotNonAuraEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent;
        if (this.affectedObjectList.isEmpty()) {
            permanent = game.getPermanentEntering(source.getSourceId());
            if (permanent == null) {
                permanent = game.getPermanent(source.getSourceId());
                if (permanent == null) {
                    this.discard();
                    return false;
                }
                this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game));
            }
        } else {
            permanent = ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game);
            if (permanent == null) {
                this.discard();
                return true;
            }
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeSubType(game, SubType.AURA);
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                ArrayList<Ability> toRemove = new ArrayList<Ability>();
                for (Ability ability : permanent.getAbilities(game)) {
                    if (!(ability instanceof EnchantAbility)) continue;
                    toRemove.add(ability);
                }
                permanent.removeAbilities(toRemove, source.getSourceId(), game);
                permanent.addAbility((Ability)new TakklemaggotUpkeepAbility(this.playerId), source.getSourceId(), game);
                return true;
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return Layer.AbilityAddingRemovingEffects_6 == layer || Layer.TypeChangingEffects_4 == layer;
    }
}

