/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TalionTheKindlyLordEffect
extends OneShotEffect {
    TalionTheKindlyLordEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a number between 1 and 10";
    }

    private TalionTheKindlyLordEffect(TalionTheKindlyLordEffect effect) {
        super((OneShotEffect)effect);
    }

    public TalionTheKindlyLordEffect copy() {
        return new TalionTheKindlyLordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return true;
        }
        int numberChoice = controller.getAmount(1, 10, "Choose a number.", source, game);
        game.getState().setValue("chosenNumber_" + source.getSourceId() + '_' + source.getStackMomentSourceZCC(), (Object)numberChoice);
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null) {
            permanent.addInfo("chosen players", "<font color = 'blue'>Chosen Number: " + numberChoice + "</font>", game);
            game.informPlayers(permanent.getLogName() + ", chosen number: " + numberChoice);
        }
        return true;
    }
}

