/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TalonGatesOfMadaraEffect
extends OneShotEffect {
    TalonGatesOfMadaraEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put {this} from your hand onto the battlefield.";
    }

    private TalonGatesOfMadaraEffect(TalonGatesOfMadaraEffect effect) {
        super((OneShotEffect)effect);
    }

    public TalonGatesOfMadaraEffect copy() {
        return new TalonGatesOfMadaraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getHand().get(source.getSourceId(), game);
        if (card == null) {
            return false;
        }
        return controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

