/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class TalonOfPainTriggeredAbility
extends TriggeredAbilityImpl {
    public TalonOfPainTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.CHARGE.createInstance()));
        this.setTriggerPhrase("Whenever a source you control other than {this} deals damage to an opponent, ");
    }

    private TalonOfPainTriggeredAbility(TalonOfPainTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TalonOfPainTriggeredAbility copy() {
        return new TalonOfPainTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player controller = game.getPlayer(this.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.hasOpponent(event.getTargetId(), game)) {
            UUID sourceControllerId = game.getControllerId(event.getSourceId());
            return sourceControllerId != null && sourceControllerId.equals(this.getControllerId()) && !this.getSourceId().equals(event.getSourceId());
        }
        return false;
    }
}

