/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TamiyoCollectorOfTalesEffect
extends OneShotEffect {
    TamiyoCollectorOfTalesEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a nonland card name, then reveal the top four cards of your library. Put all cards with the chosen name from among them into your hand and the rest into your graveyard.";
    }

    private TamiyoCollectorOfTalesEffect(TamiyoCollectorOfTalesEffect effect) {
        super((OneShotEffect)effect);
    }

    public TamiyoCollectorOfTalesEffect copy() {
        return new TamiyoCollectorOfTalesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.NON_LAND_NAME.getChoice(player, game, source, false);
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 4));
        CardsImpl cards2 = new CardsImpl();
        player.revealCards(source, (Cards)cards, game);
        for (Card card : cards.getCards(game)) {
            if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
            cards2.add(card);
        }
        cards.removeAll((Collection)cards2);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        player.moveCards((Cards)cards2, Zone.HAND, source, game);
        return true;
    }
}

