/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.CardUtil;

class TamiyoCompleatedSageEffect
extends OneShotEffect {
    TamiyoCompleatedSageEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target nonland permanent card with mana value X from your graveyard. Create a token that's a copy of that card";
    }

    private TamiyoCompleatedSageEffect(TamiyoCompleatedSageEffect effect) {
        super((OneShotEffect)effect);
    }

    public TamiyoCompleatedSageEffect copy() {
        return new TamiyoCompleatedSageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        return new CreateTokenCopyTargetEffect().setSavedPermanent((Permanent)new PermanentCard(CardUtil.getDefaultCardSideForBattlefield((Game)game, (Card)card), source.getControllerId(), game)).apply(game, source);
    }
}

