/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TamiyosCompleationTapEffect
extends OneShotEffect {
    TamiyosCompleationTapEffect() {
        super(Outcome.Tap);
        this.staticText = "tap enchanted permanent. If it's an Equipment, unattach it";
    }

    private TamiyosCompleationTapEffect(TamiyosCompleationTapEffect effect) {
        super((OneShotEffect)effect);
    }

    public TamiyosCompleationTapEffect copy() {
        return new TamiyosCompleationTapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchanted;
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment != null && (enchanted = game.getPermanent(enchantment.getAttachedTo())) != null) {
            Permanent creature;
            enchanted.tap(source, game);
            if (enchanted.hasSubtype(SubType.EQUIPMENT, game) && (creature = game.getPermanent(enchanted.getAttachedTo())) != null) {
                creature.removeAttachment(enchanted.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

