/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TarielReckonerOfSoulsEffect
extends OneShotEffect {
    TarielReckonerOfSoulsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Choose a creature card at random from target opponent's graveyard. Put that card onto the battlefield under your control";
    }

    private TarielReckonerOfSoulsEffect(TarielReckonerOfSoulsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TarielReckonerOfSoulsEffect copy() {
        return new TarielReckonerOfSoulsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetOpponent != null) {
            CardsImpl creatureCards = new CardsImpl();
            for (Card card : targetOpponent.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)) {
                creatureCards.add(card);
            }
            if (!creatureCards.isEmpty()) {
                Card card = creatureCards.getRandom(game);
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

