/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TashaTheWitchQueenCastEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    TashaTheWitchQueenCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast a spell from among cards in exile with page counters on them without paying its mana cost";
    }

    private TashaTheWitchQueenCastEffect(TashaTheWitchQueenCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public TashaTheWitchQueenCastEffect copy() {
        return new TashaTheWitchQueenCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getExile().getCardsInRange(filter, source.getControllerId(), source, game));
        return !cards.isEmpty() && CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
    }

    static {
        filter.add((Predicate)CounterType.PAGE.getPredicate());
    }
}

