/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class TashaTheWitchQueenExileEffect
extends OneShotEffect {
    TashaTheWitchQueenExileEffect() {
        super(Outcome.Benefit);
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
        this.staticText = "For each opponent, exile up to one target instant or sorcery card from that player's graveyard and put a page counter on it";
    }

    private TashaTheWitchQueenExileEffect(TashaTheWitchQueenExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public TashaTheWitchQueenExileEffect copy() {
        return new TashaTheWitchQueenExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        for (Card card : cards.getCards(game)) {
            card.addCounters(CounterType.PAGE.createInstance(), source, game);
        }
        return true;
    }
}

