/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetOpponent;

class TasigurTheGoldenFangEffect
extends OneShotEffect {
    TasigurTheGoldenFangEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = ", then return a nonland card of an opponent's choice from your graveyard to your hand";
    }

    private TasigurTheGoldenFangEffect(TasigurTheGoldenFangEffect effect) {
        super((OneShotEffect)effect);
    }

    public TasigurTheGoldenFangEffect copy() {
        return new TasigurTheGoldenFangEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player opponent;
            UUID opponentId = null;
            if (game.getOpponents(controller.getId()).size() > 1) {
                TargetOpponent target = new TargetOpponent(true);
                if (controller.chooseTarget(this.outcome, (Target)target, source, game)) {
                    opponentId = target.getFirstTarget();
                }
            } else {
                opponentId = (UUID)game.getOpponents(controller.getId()).iterator().next();
            }
            if (opponentId != null && (opponent = game.getPlayer(opponentId)) != null) {
                FilterNonlandCard filter = new FilterNonlandCard("nonland card from " + controller.getLogName() + " graveyard");
                filter.add((Predicate)new OwnerIdPredicate(controller.getId()));
                TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)filter);
                target.withNotTarget(true);
                opponent.chooseTarget(this.outcome, (Target)target, source, game);
                Card card = game.getCard(target.getFirstTarget());
                if (card != null) {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

