/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TavernBrawlerEffect
extends OneShotEffect {
    TavernBrawlerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. This creature gets +X/+0 until end of turn, where X is that card's mana value. You may play that card this turn";
    }

    private TavernBrawlerEffect(TavernBrawlerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TavernBrawlerEffect copy() {
        return new TavernBrawlerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        game.addEffect((ContinuousEffect)new BoostSourceEffect(card.getManaValue(), 0, Duration.EndOfTurn), source);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        return true;
    }
}

