/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TawnossCoffinEffect
extends OneShotEffect {
    private static final FilterEnchantmentPermanent filter = new FilterEnchantmentPermanent();

    public TawnossCoffinEffect() {
        super(Outcome.Neutral);
        this.staticText = "exile target creature and all Auras attached to it. Note the number and kind of counters that were on that creature";
    }

    private TawnossCoffinEffect(TawnossCoffinEffect effect) {
        super((OneShotEffect)effect);
    }

    public TawnossCoffinEffect copy() {
        return new TawnossCoffinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || sourceObject == null || creature == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
        String uniqueKey = exileZoneId.toString() + source.getId().toString();
        HashMap<String, Object> exileData = new HashMap<String, Object>();
        HashSet<Permanent> toExile = new HashSet<Permanent>();
        toExile.add(creature);
        HashMap creatureToAurasMap = new HashMap();
        ArrayList<UUID> auras = new ArrayList<UUID>();
        for (UUID attachmentId : creature.getAttachments()) {
            Permanent attachment = game.getPermanent(attachmentId);
            if (attachment == null || !attachment.hasSubtype(SubType.AURA, game)) continue;
            toExile.add(attachment);
            auras.add(attachmentId);
        }
        creatureToAurasMap.put(creature.getId(), auras);
        controller.moveCardsToExile(toExile, source, game, true, exileZoneId, sourceObject.getIdName());
        exileData.put("NotedCounters", creature.getCounters(game).copy());
        exileData.put("Creature", creature.getId());
        exileData.put("Auras", creatureToAurasMap);
        game.getState().setValue(uniqueKey, exileData);
        ArrayList<String> exiledKeys = (ArrayList<String>)game.getState().getValue(exileZoneId.toString() + "ExiledKeys");
        if (exiledKeys == null) {
            exiledKeys = new ArrayList<String>();
        }
        exiledKeys.add(uniqueKey);
        game.getState().setValue(exileZoneId.toString() + "ExiledKeys", exiledKeys);
        return true;
    }

    static {
        filter.add((Predicate)SubType.AURA.getPredicate());
    }
}

