/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TawnossTinkeringEffect
extends OneShotEffect {
    TawnossTinkeringEffect() {
        super(Outcome.Benefit);
        this.staticText = "if it isn't a creature, it becomes a 0/0 creature in addition to its other types";
    }

    private TawnossTinkeringEffect(TawnossTinkeringEffect effect) {
        super((OneShotEffect)effect);
    }

    public TawnossTinkeringEffect copy() {
        return new TawnossTinkeringEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || permanent.isCreature(game)) {
            return false;
        }
        game.addEffect(new BecomesCreatureTargetEffect((Token)new CreatureToken(0, 0), false, false, Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

