/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveCounterCost;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TayamLuminousEnigmaCost
extends RemoveCounterCost {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("a creature with a counter among creatures you control");

    public TayamLuminousEnigmaCost() {
        super((Target)new TargetPermanent(1, 1, (FilterPermanent)filter, true), null, 3);
    }

    private TayamLuminousEnigmaCost(TayamLuminousEnigmaCost cost) {
        super((RemoveCounterCost)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        this.paid = false;
        int countersRemoved = 0;
        Player controller = game.getPlayer(controllerId);
        for (int i = 0; i < this.countersToRemove && this.target.choose(Outcome.UnboostCreature, controllerId, source.getSourceId(), source, game); ++i) {
            Permanent permanent = game.getPermanent(this.target.getFirstTarget());
            if (permanent == null || permanent.getCounters(game).isEmpty()) continue;
            String counterName = null;
            if (permanent.getCounters(game).size() > 1) {
                ChoiceImpl choice = new ChoiceImpl(true);
                LinkedHashSet<String> choices = new LinkedHashSet<String>();
                for (Counter counter : permanent.getCounters(game).values()) {
                    if (permanent.getCounters(game).getCount(counter.getName()) <= 0) continue;
                    choices.add(counter.getName());
                }
                choice.setChoices(choices);
                choice.setMessage("Choose a counter to remove from " + permanent.getLogName());
                if (!controller.choose(Outcome.UnboostCreature, (Choice)choice, game)) {
                    return false;
                }
                counterName = choice.getChoice();
            } else {
                for (Counter counter : permanent.getCounters(game).values()) {
                    if (counter.getCount() <= 0) continue;
                    counterName = counter.getName();
                }
            }
            if (counterName == null) continue;
            permanent.removeCounters(counterName, 1, source, game);
            this.target.clearChosen();
            if (!game.isSimulation()) {
                game.informPlayers(controller.getLogName() + " removes a " + counterName + " counter from " + permanent.getName());
            }
            if (++countersRemoved != this.countersToRemove) continue;
            this.paid = true;
            break;
        }
        return this.paid;
    }

    public TayamLuminousEnigmaCost copy() {
        return new TayamLuminousEnigmaCost(this);
    }

    public String getText() {
        return "Remove three counters from among creatures you control";
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

